/*
 * File: Border.java
 * ==============================================================
 * A class representing the border of a state.  Each state's border
 * may include several smaller islands or pieces, so the border is
 * specified as a list of the shapes that make it up.
 */
import java.util.*;

public class Border {
	/* The actual shapes in the border. */
	private List<Shape> shapes;
	
	/**
	 * Constructs a border from a list of the shapes in the border.
	 * 
	 * @param shapes The shapes in the border.
	 */
	public Border(List<Shape> shapes) {
		this.shapes = shapes;
	}
	
	/**
	 * Returns how many shapes are in the border.
	 * 
	 * @return The number of shapes in the border.
	 */
	public int numShapes() {
		return shapes.size();
	}
	
	/**
	 * Returns an iterator that traverses the shapes in the border.
	 * 
	 * @return An iterator to traverse the shapes in the border.
	 */
	public Iterator<Shape> iterator() {
		return shapes.iterator();
	}
}
